AllVideos
=========

AllVideos (by JoomlaWorks) is the universal media player for Joomla and a classic must-have extension for any Joomla based website.

Use the plugin to easily embed video & audio content from all major 3rd party media providers (in alphabetical order: Dailymotion, Facebook, Flickr, Mixcloud, SoundCloud, Twitch, Vimeo, YouTube) inside your Joomla articles, K2, Virtuemart, Kunena or any other Joomla component that supports "content" plugins.

Additionally, it allows you to playback any web-native video/audio file format hosted on your server or even a remote server, providing great flexibility when it comes to media content embedding. Fun videos, product presentations, audio podcasts, you name it!


## WHY ALLVIDEOS?
- You don't have to copy/paste huge blocks of HTML code, just to get a video from YouTube to playback on your Joomla website. Your WYSIWYG editor in Joomla loves it and so will you and your clients!
- You use simple plugin tags like `{youtube}https://www.youtube.com/watch?v=0u_g6zNuP_I{/youtube}` (or just `{youtube}0u_g6zNuP_I{/youtube}`), `{mp4}summer_vacation_in_rome{/mp4}` or `{mp3}pixies_bonemachine{/mp3}`.


## FEATURES
1. All major 3rd party media providers are supported: Dailymotion, Facebook (for videos), Flickr (for videos), Mixcloud, SoundCloud, Twitch, Vimeo, YouTube (single videos & playlists). Use simple plugin tags utilizing the full media page URL (e.g. `{youtube}https://www.youtube.com/watch?v=0u_g6zNuP_I{/youtube}`) or just the ID from the media URL page (e.g `{youtube}0u_g6zNuP_I{/youtube}`).
2. Stream your own media content using web-native video and audio formats like H.264/MPEG-4 (.mp4/.m4v/.m4a), WebM (.webm), Ogg Theora Vorbis (.ogg/.ogv/.oga), MP3 (.mp3), WAVE PCM (.wav) & FLAC (.flac), as well as generic containers like .avi & .mkv. For non web-native media embedded with older version of AllVideos (prior to version 5.0.0), which are not supported by modern browsers, a download message will be presented - this basically includes Flash Video (.flv/.f4v), ShockWave Flash (.swf), Windows Media (.wmv/.wma), QuickTime (.mov/.mpg/.mpeg/.3gp/.3g2/.aac), DivX (.divx) etc.
3. Easily embed your media content either directly from your server or a remote server.
4. Use custom preview (poster) images for self-hosted video & audio files. For videos specifically (and unlike any other similar solution in Joomla), AllVideos can auto-generate preview images from the 5th second of each video by utilizing modern browser features.
5. Need a simple way to have random preview images for your self-hosted audio files? Enable the Unsplash.com integration and your audio files will use random music/audio related images as previews from the popular stock image service.
6. Use AllVideos to display background videos with muted sound.
7. Simple controls inside the plugin's parameters page provide layout consistency on all the videos shown in your Joomla website. Set your preferences in seconds, publish the plugin and you're ready to start embedding media content!
8. Easy, descriptive syntax for media embedding - `{format OR provider}filename{/format OR provider}`. You can also use syntax like `{format OR provider}filename|width|height|autoplay{/format OR provider}` (e.g. an "autoplaying" YouTube video with `{youtube}he73js82|600|450|1{/youtube}`) to display media at different dimensions.
9. Uses MVC templating. Just copy the /tmpl folder included in the plugin, into your Joomla template's /html folder and rename it to "jw_allvideos", then style the output as you wish.
10. Includes 3 templates: Classic, Framed and Responsive
11. Fully responsive media playback when using the "Responsive" template.
12. Uses the core Joomla updater.


## COMPATIBILITY
AllVideos is fully compatible with Joomla versions 1.5, 2.5, 3.x, 4.x & 5.x on servers running PHP 5, 7 or 8.


## LICENSE
AllVideos is a Joomla plugin developed by JoomlaWorks, released under the GNU General Public License.


## LEARN MORE
Visit the AllVideos product page at: [https://www.joomlaworks.net/allvideos](https://www.joomlaworks.net/allvideos)

Last update: June 17th, 2025 - Version 7.0
